/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.exporters;

import LegendaryCardMaker.CustomCardMaker.structure.CustomCard;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCard;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ExportProgressBarDialog
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JProgressBar progressBar;
    private Task task;
    private int maxValue;
    private int currentValue;
    private LegendaryCardMaker lcm;
    private File folder;
    private JDialog frame;
    private boolean jpegMode = false;

    public ExportProgressBarDialog(int maxValue, LegendaryCardMaker lcm, File folder) {
        super(new BorderLayout());
        this.lcm = lcm;
        this.folder = folder;
        this.maxValue = maxValue;
        this.progressBar = new JProgressBar(0, maxValue);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        JPanel panel = new JPanel();
        panel.add(this.progressBar);
        this.add((Component)panel, "First");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    public void createAndShowGUI() {
        this.frame = new JDialog();
        this.frame.setTitle("Exporting (" + (this.getCurrentValue() + 1) + "/" + this.getMaxValue() + ")...");
        this.frame.setModal(true);
        this.frame.setDefaultCloseOperation(2);
        this.setOpaque(true);
        this.frame.setContentPane(this);
        this.task = new Task();
        this.task.setBar(this);
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void hideGUI() {
        this.frame.setVisible(false);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public boolean isJpegMode() {
        return this.jpegMode;
    }

    public void setJpegMode(boolean jpegMode) {
        this.jpegMode = jpegMode;
    }

    class Task
    extends SwingWorker<Void, Void> {
        private ExportProgressBarDialog bar;

        Task() {
        }

        @Override
        public Void doInBackground() throws Exception {
            for (Hero hero : ((ExportProgressBarDialog)ExportProgressBarDialog.this).lcm.heroes) {
                if (ExportProgressBarDialog.this.jpegMode) {
                    ExportProgressBarDialog.this.lcm.exportHeroToJpeg(hero, ExportProgressBarDialog.this.folder);
                } else {
                    ExportProgressBarDialog.this.lcm.exportHeroToPng(hero, ExportProgressBarDialog.this.folder);
                }
                ExportProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportProgressBarDialog.this.getMaxValue() + ")...");
                ExportProgressBarDialog exportProgressBarDialog = ExportProgressBarDialog.this;
                int n = exportProgressBarDialog.currentValue;
                exportProgressBarDialog.currentValue = n + 1;
                this.setProgress(n);
            }
            for (Villain villain : ((ExportProgressBarDialog)ExportProgressBarDialog.this).lcm.villains) {
                if (ExportProgressBarDialog.this.jpegMode) {
                    ExportProgressBarDialog.this.lcm.exportVillainToJpeg(villain, ExportProgressBarDialog.this.folder);
                } else {
                    ExportProgressBarDialog.this.lcm.exportVillainToPng(villain, ExportProgressBarDialog.this.folder);
                }
                ExportProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportProgressBarDialog.this.getMaxValue() + ")...");
                ExportProgressBarDialog exportProgressBarDialog = ExportProgressBarDialog.this;
                int n = exportProgressBarDialog.currentValue;
                exportProgressBarDialog.currentValue = n + 1;
                this.setProgress(n);
            }
            for (SchemeCard schemeCard : ((ExportProgressBarDialog)ExportProgressBarDialog.this).lcm.schemes) {
                if (ExportProgressBarDialog.this.jpegMode) {
                    ExportProgressBarDialog.this.lcm.exportSchemeToJpeg(schemeCard, ExportProgressBarDialog.this.folder);
                } else {
                    ExportProgressBarDialog.this.lcm.exportSchemeToPng(schemeCard, ExportProgressBarDialog.this.folder);
                }
                ExportProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportProgressBarDialog.this.getMaxValue() + ")...");
                ExportProgressBarDialog exportProgressBarDialog = ExportProgressBarDialog.this;
                int n = exportProgressBarDialog.currentValue;
                exportProgressBarDialog.currentValue = n + 1;
                this.setProgress(n);
            }
            for (CustomCard customCard : ((ExportProgressBarDialog)ExportProgressBarDialog.this).lcm.customCards) {
                if (ExportProgressBarDialog.this.jpegMode) {
                    ExportProgressBarDialog.this.lcm.exportCustomCardToJpeg(customCard, ExportProgressBarDialog.this.folder);
                } else {
                    ExportProgressBarDialog.this.lcm.exportCustomCardToPng(customCard, ExportProgressBarDialog.this.folder);
                }
                ExportProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportProgressBarDialog.this.getMaxValue() + ")...");
                ExportProgressBarDialog exportProgressBarDialog = ExportProgressBarDialog.this;
                int n = exportProgressBarDialog.currentValue;
                exportProgressBarDialog.currentValue = n + 1;
                this.setProgress(n);
            }
            return null;
        }

        @Override
        public void done() {
            this.bar.hideGUI();
        }

        public ExportProgressBarDialog getBar() {
            return this.bar;
        }

        public void setBar(ExportProgressBarDialog bar) {
            this.bar = bar;
        }
    }
}

